using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;

namespace SFNET_CSharp_2003
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class Form1 : System.Windows.Forms.Form
	{
		private System.Windows.Forms.TextBox textboxLevelMin;
		private System.Windows.Forms.TextBox textboxLevelMax;
		private System.Windows.Forms.TextBox textboxLevelInt;
		private System.Windows.Forms.TrackBar trackbarLevel;
		private SymbolFactoryDotNet.StandardControl sfnetTank;
		private SymbolFactoryDotNet.CutawayControl sfnetCutaway;
		private System.Windows.Forms.RadioButton radiobuttonValueOn;
		private System.Windows.Forms.RadioButton radiobuttonValueOff;
		private System.Windows.Forms.TrackBar trackbarTruck;
		private SymbolFactoryDotNet.StandardControl sfnetTruck;
		private SymbolFactoryDotNet.StandardControl sfnetValve;
		//
		private double distanceMultiplier;
		private int startTruck;
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.Label label4;
		private System.Windows.Forms.Button buttonExit;
		private SymbolFactoryDotNet.StandardControl sfnetBlower;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public Form1()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();
			//
			// Construction of the default component values
			//
			trackbarLevel.Value = 0;
			sfnetCutaway.Level = (double)trackbarLevel.Value;
			sfnetBlower.AnalogIntValue1 = (short)trackbarLevel.Value;
			textboxLevelMax.Text = trackbarLevel.Maximum.ToString();
			textboxLevelMin.Text = trackbarLevel.Minimum.ToString();
			textboxLevelInt.Text = trackbarLevel.Value.ToString();
			sfnetValve.BandsCollection[0].DiscreteValue = true;
			sfnetValve.BandsCollection[1].DiscreteValue = false;
			//
			// Compute distance for the truck to travel
			//
			int truckDistance = this.Size.Width - sfnetTruck.Width - sfnetTruck.Left;
			distanceMultiplier = truckDistance / (trackbarTruck.Maximum - trackbarTruck.Minimum);
			trackbarTruck.Value = 0;
			startTruck = sfnetTruck.Left;
			sfnetTruck.Left = (int)(startTruck + (int)(trackbarTruck.Value*distanceMultiplier));
			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(Form1));
			this.trackbarLevel = new System.Windows.Forms.TrackBar();
			this.textboxLevelMin = new System.Windows.Forms.TextBox();
			this.textboxLevelMax = new System.Windows.Forms.TextBox();
			this.textboxLevelInt = new System.Windows.Forms.TextBox();
			this.sfnetTank = new SymbolFactoryDotNet.StandardControl();
			this.sfnetCutaway = new SymbolFactoryDotNet.CutawayControl();
			this.sfnetValve = new SymbolFactoryDotNet.StandardControl();
			this.radiobuttonValueOn = new System.Windows.Forms.RadioButton();
			this.radiobuttonValueOff = new System.Windows.Forms.RadioButton();
			this.trackbarTruck = new System.Windows.Forms.TrackBar();
			this.sfnetTruck = new SymbolFactoryDotNet.StandardControl();
			this.pictureBox1 = new System.Windows.Forms.PictureBox();
			this.label1 = new System.Windows.Forms.Label();
			this.label2 = new System.Windows.Forms.Label();
			this.label3 = new System.Windows.Forms.Label();
			this.label4 = new System.Windows.Forms.Label();
			this.buttonExit = new System.Windows.Forms.Button();
			this.sfnetBlower = new SymbolFactoryDotNet.StandardControl();
			((System.ComponentModel.ISupportInitialize)(this.trackbarLevel)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.sfnetTank)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.sfnetCutaway)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.sfnetValve)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.trackbarTruck)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.sfnetTruck)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.sfnetBlower)).BeginInit();
			this.SuspendLayout();
			// 
			// trackbarLevel
			// 
			this.trackbarLevel.LargeChange = 1;
			this.trackbarLevel.Location = new System.Drawing.Point(176, 128);
			this.trackbarLevel.Maximum = 100;
			this.trackbarLevel.Name = "trackbarLevel";
			this.trackbarLevel.Orientation = System.Windows.Forms.Orientation.Vertical;
			this.trackbarLevel.Size = new System.Drawing.Size(42, 184);
			this.trackbarLevel.TabIndex = 1;
			this.trackbarLevel.TickFrequency = 10;
			this.trackbarLevel.Scroll += new System.EventHandler(this.trackbarLevel_Scroll);
			// 
			// textboxLevelMin
			// 
			this.textboxLevelMin.Location = new System.Drawing.Point(240, 288);
			this.textboxLevelMin.Name = "textboxLevelMin";
			this.textboxLevelMin.ReadOnly = true;
			this.textboxLevelMin.Size = new System.Drawing.Size(40, 20);
			this.textboxLevelMin.TabIndex = 2;
			this.textboxLevelMin.Text = "";
			// 
			// textboxLevelMax
			// 
			this.textboxLevelMax.Location = new System.Drawing.Point(232, 120);
			this.textboxLevelMax.Name = "textboxLevelMax";
			this.textboxLevelMax.ReadOnly = true;
			this.textboxLevelMax.Size = new System.Drawing.Size(40, 20);
			this.textboxLevelMax.TabIndex = 3;
			this.textboxLevelMax.Text = "";
			// 
			// textboxLevelInt
			// 
			this.textboxLevelInt.Location = new System.Drawing.Point(328, 224);
			this.textboxLevelInt.Name = "textboxLevelInt";
			this.textboxLevelInt.ReadOnly = true;
			this.textboxLevelInt.Size = new System.Drawing.Size(40, 20);
			this.textboxLevelInt.TabIndex = 4;
			this.textboxLevelInt.Text = "";
			// 
			// sfnetTank
			// 
			this.sfnetTank.AnalogIntValue1 = ((short)(0));
			this.sfnetTank.AnalogValue1 = 0;
			this.sfnetTank.Band1Breakpoint = 0;
			this.sfnetTank.Band1Color = System.Drawing.Color.Red;
			this.sfnetTank.Band1IntBreakpoint = 0;
			this.sfnetTank.Band2Breakpoint = 0;
			this.sfnetTank.Band2Color = System.Drawing.Color.Yellow;
			this.sfnetTank.Band2IntBreakpoint = 0;
			this.sfnetTank.Band3Breakpoint = 0;
			this.sfnetTank.Band3Color = System.Drawing.Color.Green;
			this.sfnetTank.Band3IntBreakpoint = 0;
			this.sfnetTank.Band4Breakpoint = 0;
			this.sfnetTank.Band4Color = System.Drawing.Color.Yellow;
			this.sfnetTank.Band4IntBreakpoint = 0;
			this.sfnetTank.Band5Color = System.Drawing.Color.Red;
			this.sfnetTank.BandCount = ((short)(0));
			this.sfnetTank.BlinkColor = System.Drawing.Color.Red;
			this.sfnetTank.Category = "1TANK.cat2";
			this.sfnetTank.DebugData = ((SymbolFactoryDotNet.DebugClass)(resources.GetObject("sfnetTank.DebugData")));
			this.sfnetTank.FillColor = System.Drawing.Color.DarkGreen;
			this.sfnetTank.Location = new System.Drawing.Point(272, 112);
			this.sfnetTank.Name = "sfnetTank";
			this.sfnetTank.Size = new System.Drawing.Size(112, 200);
			this.sfnetTank.Stretch = true;
			this.sfnetTank.SymbolHandle = ((long)(1718925109));
			this.sfnetTank.TabIndex = 5;
			this.sfnetTank.VisibleAnimationMode = ((long)(99));
			// 
			// sfnetCutaway
			// 
			this.sfnetCutaway.AnimationMode = AnimationModeOptions.AnalogColorFill;
			this.sfnetCutaway.Band1Breakpoint = 0;
			this.sfnetCutaway.Band1Color = System.Drawing.Color.Red;
			this.sfnetCutaway.Band1IntBreakpoint = 0;
			this.sfnetCutaway.Band1Style = CutawayBandStyleOptions.BandOriginalColor;
			this.sfnetCutaway.Band2Breakpoint = 0;
			this.sfnetCutaway.Band2Color = System.Drawing.Color.Yellow;
			this.sfnetCutaway.Band2IntBreakpoint = 0;
			this.sfnetCutaway.Band2Style = CutawayBandStyleOptions.BandOriginalColor;
			this.sfnetCutaway.Band3Breakpoint = 0;
			this.sfnetCutaway.Band3Color = System.Drawing.Color.Green;
			this.sfnetCutaway.Band3IntBreakpoint = 0;
			this.sfnetCutaway.Band4Breakpoint = 0;
			this.sfnetCutaway.Band4Color = System.Drawing.Color.Yellow;
			this.sfnetCutaway.Band4IntBreakpoint = 0;
			this.sfnetCutaway.Band4Style = CutawayBandStyleOptions.BandOriginalColor;
			this.sfnetCutaway.Band5Color = System.Drawing.Color.Red;
			this.sfnetCutaway.Band5Style = CutawayBandStyleOptions.BandOriginalColor;
			this.sfnetCutaway.BandCount = ((short)(0));
			this.sfnetCutaway.BlinkColor = System.Drawing.Color.Red;
			this.sfnetCutaway.EmptyColor = System.Drawing.Color.FromArgb(((System.Byte)(50)), ((System.Byte)(50)), ((System.Byte)(50)));
			this.sfnetCutaway.FillColor = System.Drawing.Color.FromArgb(((System.Byte)(0)), ((System.Byte)(0)), ((System.Byte)(255)));
			this.sfnetCutaway.Location = new System.Drawing.Point(296, 160);
			this.sfnetCutaway.Name = "sfnetCutaway";
			this.sfnetCutaway.Size = new System.Drawing.Size(30, 88);
			this.sfnetCutaway.TabIndex = 6;
			this.sfnetCutaway.VisibleAnimationMode = ((long)(99));
			// 
			// sfnetValve
			// 
			this.sfnetValve.AnalogIntValue1 = ((short)(0));
			this.sfnetValve.AnalogValue1 = 0;
			this.sfnetValve.AnimationMode = AnimationModeOptions.DiscreteColorFill;
			this.sfnetValve.Band1Breakpoint = 0;
			this.sfnetValve.Band1Color = System.Drawing.Color.Lime;
			this.sfnetValve.Band1IntBreakpoint = 0;
			this.sfnetValve.Band1Style = BandStyleOptions.Shaded;
			this.sfnetValve.Band2Breakpoint = 0;
			this.sfnetValve.Band2Color = System.Drawing.Color.Red;
			this.sfnetValve.Band2IntBreakpoint = 0;
			this.sfnetValve.Band2Style = BandStyleOptions.Shaded;
			this.sfnetValve.Band3Breakpoint = 0;
			this.sfnetValve.Band3Color = System.Drawing.Color.Green;
			this.sfnetValve.Band3IntBreakpoint = 0;
			this.sfnetValve.Band4Breakpoint = 0;
			this.sfnetValve.Band4Color = System.Drawing.Color.Yellow;
			this.sfnetValve.Band4IntBreakpoint = 0;
			this.sfnetValve.Band5Color = System.Drawing.Color.Red;
			this.sfnetValve.BandCount = ((short)(2));
			this.sfnetValve.BandsCollection.Add(((SymbolFactoryNetEngine.Band)(resources.GetObject("resource"))));
			this.sfnetValve.BandsCollection.Add(((SymbolFactoryNetEngine.Band)(resources.GetObject("resource1"))));
			this.sfnetValve.BlinkColor = System.Drawing.Color.Red;
			this.sfnetValve.Category = "1VLV.cat2";
			this.sfnetValve.DebugData = ((SymbolFactoryDotNet.DebugClass)(resources.GetObject("sfnetValve.DebugData")));
			this.sfnetValve.FillColor = System.Drawing.Color.DarkGreen;
			this.sfnetValve.Location = new System.Drawing.Point(416, 184);
			this.sfnetValve.Name = "sfnetValve";
			this.sfnetValve.Size = new System.Drawing.Size(121, 121);
			this.sfnetValve.SymbolHandle = ((long)(388779757));
			this.sfnetValve.TabIndex = 7;
			this.sfnetValve.VisibleAnimationMode = ((long)(99));
			// 
			// radiobuttonValueOn
			// 
			this.radiobuttonValueOn.Checked = true;
			this.radiobuttonValueOn.Location = new System.Drawing.Point(416, 112);
			this.radiobuttonValueOn.Name = "radiobuttonValueOn";
			this.radiobuttonValueOn.TabIndex = 8;
			this.radiobuttonValueOn.TabStop = true;
			this.radiobuttonValueOn.Text = "Value On";
			this.radiobuttonValueOn.CheckedChanged += new System.EventHandler(this.radiobuttonValueOn_CheckedChanged);
			// 
			// radiobuttonValueOff
			// 
			this.radiobuttonValueOff.Location = new System.Drawing.Point(416, 144);
			this.radiobuttonValueOff.Name = "radiobuttonValueOff";
			this.radiobuttonValueOff.TabIndex = 9;
			this.radiobuttonValueOff.Text = "Value Off";
			this.radiobuttonValueOff.CheckedChanged += new System.EventHandler(this.radiobuttonValueOff_CheckedChanged);
			// 
			// trackbarTruck
			// 
			this.trackbarTruck.LargeChange = 1;
			this.trackbarTruck.Location = new System.Drawing.Point(8, 408);
			this.trackbarTruck.Maximum = 100;
			this.trackbarTruck.Name = "trackbarTruck";
			this.trackbarTruck.Size = new System.Drawing.Size(560, 42);
			this.trackbarTruck.TabIndex = 10;
			this.trackbarTruck.TickFrequency = 10;
			this.trackbarTruck.Scroll += new System.EventHandler(this.trackbarTruck_Scroll);
			// 
			// sfnetTruck
			// 
			this.sfnetTruck.AnalogIntValue1 = ((short)(0));
			this.sfnetTruck.AnalogValue1 = 0;
			this.sfnetTruck.Band1Breakpoint = 0;
			this.sfnetTruck.Band1Color = System.Drawing.Color.Red;
			this.sfnetTruck.Band1IntBreakpoint = 0;
			this.sfnetTruck.Band2Breakpoint = 0;
			this.sfnetTruck.Band2Color = System.Drawing.Color.Yellow;
			this.sfnetTruck.Band2IntBreakpoint = 0;
			this.sfnetTruck.Band3Breakpoint = 0;
			this.sfnetTruck.Band3Color = System.Drawing.Color.Green;
			this.sfnetTruck.Band3IntBreakpoint = 0;
			this.sfnetTruck.Band4Breakpoint = 0;
			this.sfnetTruck.Band4Color = System.Drawing.Color.Yellow;
			this.sfnetTruck.Band4IntBreakpoint = 0;
			this.sfnetTruck.Band5Color = System.Drawing.Color.Red;
			this.sfnetTruck.BandCount = ((short)(0));
			this.sfnetTruck.BlinkColor = System.Drawing.Color.Red;
			this.sfnetTruck.Category = "1veh.cat2";
			this.sfnetTruck.DebugData = ((SymbolFactoryDotNet.DebugClass)(resources.GetObject("sfnetTruck.DebugData")));
			this.sfnetTruck.FillColor = System.Drawing.Color.DarkGreen;
			this.sfnetTruck.Flip = FlipOptions.Horizontal;
			this.sfnetTruck.Location = new System.Drawing.Point(8, 352);
			this.sfnetTruck.Name = "sfnetTruck";
			this.sfnetTruck.Size = new System.Drawing.Size(168, 56);
			this.sfnetTruck.Stretch = true;
			this.sfnetTruck.SymbolHandle = ((long)(1532173522));
			this.sfnetTruck.TabIndex = 11;
			this.sfnetTruck.VisibleAnimationMode = ((long)(99));
			// 
			// pictureBox1
			// 
			this.pictureBox1.Location = new System.Drawing.Point(8, 8);
			this.pictureBox1.Name = "pictureBox1";
			this.pictureBox1.Size = new System.Drawing.Size(88, 48);
			this.pictureBox1.TabIndex = 12;
			this.pictureBox1.TabStop = false;
			// 
			// label1
			// 
			this.label1.Font = new System.Drawing.Font("Microsoft Sans Serif", 12F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label1.ForeColor = System.Drawing.Color.FromArgb(((System.Byte)(0)), ((System.Byte)(0)), ((System.Byte)(192)));
			this.label1.Location = new System.Drawing.Point(104, 16);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(432, 23);
			this.label1.TabIndex = 13;
			this.label1.Text = "Symbol Factory .NET Visual Studio 2003 Example - C#";
			// 
			// label2
			// 
			this.label2.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label2.Location = new System.Drawing.Point(136, 40);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(360, 32);
			this.label2.TabIndex = 14;
			this.label2.Text = "Use the track bars and radio buttons on this form to see how the Symbol Factory ." +
				"NET symbols can be animated.";
			this.label2.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// label3
			// 
			this.label3.Location = new System.Drawing.Point(16, 88);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(192, 32);
			this.label3.TabIndex = 15;
			this.label3.Text = "Drag the vertical track bar to see the Blower and Tank Values change.";
			// 
			// label4
			// 
			this.label4.Location = new System.Drawing.Point(112, 448);
			this.label4.Name = "label4";
			this.label4.Size = new System.Drawing.Size(352, 23);
			this.label4.TabIndex = 16;
			this.label4.Text = "Use the horizontal track bar to move the truck across the screen.";
			// 
			// buttonExit
			// 
			this.buttonExit.Location = new System.Drawing.Point(496, 456);
			this.buttonExit.Name = "buttonExit";
			this.buttonExit.Size = new System.Drawing.Size(64, 24);
			this.buttonExit.TabIndex = 17;
			this.buttonExit.Text = "Exit";
			this.buttonExit.Click += new System.EventHandler(this.buttonExit_Click);
			// 
			// sfnetBlower
			// 
			this.sfnetBlower.AnalogIntValue1 = ((short)(0));
			this.sfnetBlower.AnalogValue1 = 0;
			this.sfnetBlower.AnimationMode = AnimationModeOptions.AnalogIntegerColorFill;
			this.sfnetBlower.Band1Breakpoint = 90;
			this.sfnetBlower.Band1Color = System.Drawing.Color.Red;
			this.sfnetBlower.Band1Style = BandStyleOptions.BlinkShaded;
			this.sfnetBlower.Band2Breakpoint = 80;
			this.sfnetBlower.Band2Color = System.Drawing.Color.Yellow;
			this.sfnetBlower.Band2Style = BandStyleOptions.BlinkShaded;
			this.sfnetBlower.Band3Breakpoint = 70;
			this.sfnetBlower.Band3Color = System.Drawing.Color.Green;
			this.sfnetBlower.Band3Style = BandStyleOptions.BlinkShaded;
			this.sfnetBlower.Band4Breakpoint = 50;
			this.sfnetBlower.Band4Color = System.Drawing.Color.Blue;
			this.sfnetBlower.Band4Style = BandStyleOptions.Shaded;
			this.sfnetBlower.Band5Color = System.Drawing.Color.Red;
			this.sfnetBlower.Band5Style = BandStyleOptions.Shaded;
			this.sfnetBlower.BandsCollection.Add(((SymbolFactoryNetEngine.Band)(resources.GetObject("resource2"))));
			this.sfnetBlower.BandsCollection.Add(((SymbolFactoryNetEngine.Band)(resources.GetObject("resource3"))));
			this.sfnetBlower.BandsCollection.Add(((SymbolFactoryNetEngine.Band)(resources.GetObject("resource4"))));
			this.sfnetBlower.BandsCollection.Add(((SymbolFactoryNetEngine.Band)(resources.GetObject("resource5"))));
			this.sfnetBlower.BandsCollection.Add(((SymbolFactoryNetEngine.Band)(resources.GetObject("resource6"))));
			this.sfnetBlower.BandsCollection.Add(((SymbolFactoryNetEngine.Band)(resources.GetObject("resource7"))));
			this.sfnetBlower.BandsCollection.Add(((SymbolFactoryNetEngine.Band)(resources.GetObject("resource8"))));
			this.sfnetBlower.BlinkColor = System.Drawing.Color.Red;
			this.sfnetBlower.Category = "1PMP.cat2";
			this.sfnetBlower.DebugData = ((SymbolFactoryDotNet.DebugClass)(resources.GetObject("sfnetBlower.DebugData")));
			this.sfnetBlower.FillColor = System.Drawing.Color.DarkGreen;
			this.sfnetBlower.Location = new System.Drawing.Point(8, 120);
			this.sfnetBlower.Name = "sfnetBlower";
			this.sfnetBlower.Size = new System.Drawing.Size(160, 208);
			this.sfnetBlower.SymbolHandle = ((long)(26978524));
			this.sfnetBlower.TabIndex = 18;
			this.sfnetBlower.VisibleAnimationMode = ((long)(99));
			// 
			// Form1
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(576, 494);
			this.Controls.Add(this.sfnetBlower);
			this.Controls.Add(this.buttonExit);
			this.Controls.Add(this.label4);
			this.Controls.Add(this.label3);
			this.Controls.Add(this.label2);
			this.Controls.Add(this.label1);
			this.Controls.Add(this.pictureBox1);
			this.Controls.Add(this.textboxLevelMin);
			this.Controls.Add(this.sfnetTruck);
			this.Controls.Add(this.trackbarTruck);
			this.Controls.Add(this.radiobuttonValueOff);
			this.Controls.Add(this.radiobuttonValueOn);
			this.Controls.Add(this.sfnetValve);
			this.Controls.Add(this.sfnetCutaway);
			this.Controls.Add(this.textboxLevelInt);
			this.Controls.Add(this.sfnetTank);
			this.Controls.Add(this.textboxLevelMax);
			this.Controls.Add(this.trackbarLevel);
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.Name = "Form1";
			this.Text = "Symbol Factory .NET Visual Studio 2003 Example";
			((System.ComponentModel.ISupportInitialize)(this.trackbarLevel)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.sfnetTank)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.sfnetCutaway)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.sfnetValve)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.trackbarTruck)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.sfnetTruck)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.sfnetBlower)).EndInit();
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new Form1());
		}

		
		/// <summary>
		/// Handler for moving the Track Bar for the Blower and Cutaway Control
		/// </summary>
		private void trackbarLevel_Scroll(object sender, System.EventArgs e)
		{
			sfnetBlower.AnalogIntValue1 = (short)trackbarLevel.Value;
			sfnetCutaway.Level = (double)trackbarLevel.Value;
			textboxLevelInt.Text = trackbarLevel.Value.ToString();
		}

		
		/// <summary>
		/// Handler for turning ON the valve
		/// </summary>
		private void radiobuttonValueOn_CheckedChanged(object sender, System.EventArgs e)
		{
			sfnetValve.BandsCollection[0].DiscreteValue = true;
			sfnetValve.BandsCollection[1].DiscreteValue = false;
		}

		
		
		/// <summary>
		/// Handler for turning OFF the value
		/// </summary>
		private void radiobuttonValueOff_CheckedChanged(object sender, System.EventArgs e)
		{
			sfnetValve.BandsCollection[0].DiscreteValue = false;
			sfnetValve.BandsCollection[1].DiscreteValue = true;
		
		}

		
		/// <summary>
		/// Handler for moving the truck
		/// </summary>
		private void trackbarTruck_Scroll(object sender, System.EventArgs e)
		{
			sfnetTruck.Left = (int)(startTruck + (int)(trackbarTruck.Value*distanceMultiplier));
		}

		
		
		/// <summary>
		/// Handler for exiting the application via the Exit button
		/// </summary>
		private void buttonExit_Click(object sender, System.EventArgs e)
		{
			Application.Exit();
		}


	}
}
